#include <iostream>
#include <cstring>

void SetBoundaries(const char* const str, int& l, int& r, int lNew, int rNew, int* counts)
{
	if (l == INT_MAX || r == INT_MIN)
	{
		l = lNew;
		r = rNew;
		for (int i = l; i < r; ++i)
			++counts[str[i] - 'a'];
	}

	if (lNew < l)
	{
		for (int i = lNew; i < l; ++i)
			++counts[str[i] - 'a'];
		l = lNew;
	}
	else
	{
		for (int i = r; i < rNew; ++i)
			++counts[str[i] - 'a'];
		r = rNew;
	}
}

int Count(const char* const str, int n, int l, int r, int offset, int* counts)
{			
	while (offset <= n / 2)
	{
		char first = str[offset];
		char last = str[n - offset - 1];

		if (l != INT_MAX && l <= offset && r != INT_MIN && r >= n - offset)
		{
			break;
			//both unknown
		}
		else if (l != INT_MAX && l <= offset)
		{
			if (counts[last - 'a'] > 0)
			{
				--counts[last - 'a'];
				++offset;
			}
			else
			{
				int i = std::max(offset, r);

				while (true)
					if (str[i] == last)
						break;
					else
						++i;

				SetBoundaries(str, l, r, l, i + 1, counts);
				--counts[last - 'a'];
				++offset;
			}
			//only left unknown 
		}
		else if (r != INT_MIN && r >= n - offset)
		{
			if (counts[first - 'a'] > 0)
			{
				--counts[first - 'a'];
				++offset;
			}
			else
			{
				int i = std::min(l - 1, n - offset - 1);

				while (true)
					if (str[i] == first)
						break;
					else
						--i;

				SetBoundaries(str, l, r, i, r, counts);
				--counts[first - 'a'];
				++offset;
			}
			//only right unknown
		}
		else if (first != last)
		{			
			int firstLast = -1;
			int lastFirst = -1;
			for (int i = offset + 1; i < n - offset; ++i)
			{
				if (str[i] == first)
					lastFirst = i;
				else if (str[i] == last && firstLast == -1)
					firstLast = i;
			}

			int counts1[26];
			memcpy(counts1, counts, sizeof(counts1));
			int l1 = l, r1 = r;
			SetBoundaries(str, l1, r1, std::min(l, offset), firstLast + 1, counts1);
			--counts1[last - 'a'];
			int c1 = Count(str, n, l1, r1, offset + 1, counts1);

			int counts2[26];
			memcpy(counts2, counts, sizeof(counts2));
			int l2 = l, r2 = r;
			SetBoundaries(str, l2, r2, lastFirst, std::max(r, n - offset), counts2);
			--counts2[first - 'a'];
			int c2 = Count(str, n, l2, r2, offset + 1, counts2);

			if (c1 < c2)
				return c1;
			else
				return c2;
			++offset;
		} //known both, different
		else
		{
			++offset;
		} //know both, same
	}

	if (r == INT_MAX || l == INT_MIN)
		return 1;
	return r - l;
}

char str[200000];

int main()
{	
	int n = 0;
	char ch = getchar();
	while (ch != '\n')
	{
		str[n++] = ch;
		ch = getchar();		
	}

	int counts[26];
	memset(counts, 0, sizeof(counts));
	int count = Count(str, n, INT_MAX, INT_MIN, 0, counts);

	printf("%d", count);
}